package com.hero;

import java.io.File;

import org.jdom.Element;

import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Prefab extends Hero {

	public Prefab(Element root) {
		super(root);
	}

	public Prefab(Element root, Template template) {
		super(root, template);
	}

	/**
	 * Loads an existing Prefab from the specified file using the currently
	 * active template.
	 * 
	 * @param saveFile
	 *            The file that the Prefab is saved in.
	 */
	public Prefab(File saveFile) {
		super(saveFile);
	}

	/**
	 * Loads a prefab from the specified file, using the currently active
	 * template if loadPrefab is false or the template specified in the prefab
	 * if loadPrefab is true.
	 * 
	 * @param saveFile
	 * @param loadPrefab
	 */
	public Prefab(File saveFile, boolean loadPrefab) {
		super(saveFile, loadPrefab);
	}

	/**
	 * Constructs a new Prefab with the specified name.
	 * 
	 * @param name
	 * @throws Exception
	 */
	public Prefab(String name) throws Exception {
		super();
		init();
		characterName = name;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.hero.Hero#addDisad(com.hero.objects.GenericObject)
	 */
	@Override
	protected void addDisad(GenericObject val) {
		val.setIsPrefab(true);
		super.addDisad(val);
	}

	@Override
	protected void addEquipment(GenericObject val) {
		val.setIsPrefab(true);
		super.addEquipment(val);
	}

	@Override
	public void addManeuver(GenericObject val) {
		val.setIsPrefab(true);
		super.addManeuver(val);
	}

	@Override
	protected void addPerk(GenericObject val) {
		val.setIsPrefab(true);
		super.addPerk(val);
	}

	@Override
	protected void addPower(GenericObject val) {
		val.setIsPrefab(true);
		super.addPower(val);
	}

	@Override
	protected void addSkill(GenericObject val) {
		val.setIsPrefab(true);
		super.addSkill(val);
	}

	@Override
	protected void addTalent(GenericObject val) {
		val.setIsPrefab(true);
		super.addTalent(val);
	}

	public String getName() {
		if ((characterName == null) || (characterName.trim().length() == 0)) {
			characterName = getCharacterName();
		}
		if ((characterName == null) || (characterName.trim().length() == 0)) {
			characterName = "[unknown]";
		}
		return characterName;
	}

	@Override
	public Element getSaveXML() {
		Element root = super.getSaveXML();
		root.setName("PREFAB");
		return root;
	}

	@Override
	public boolean isPrefab() {
		return true;
	}

}